// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : intro.cpp
// Date           : February 2008
//
// Description    : This file defines the Extro class responsible for
//                  handling the introductory splash screen that appears
//                  just before the main menu GUI.  Once instantiated, Update()
//                  must be called within the main game loop while the intro
//                  is active.  Close() is used to determine if any key (or
//                  the LMB) has been pressed.  At which time, the application
//                  can delete Extro and create a new Menu GUI.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include "global.h"
#include "GameState.h"
#include "Level.h"



class Extro : public GameState
{

  protected:


    bool            closeIntro;     // Close intro flag
    bool            clickLeft;      // Used for "active-low" button pressing

    bool            m_SoundStarted[6];

    Level           m_Level;

    std::vector<std::string>      m_ExtroText;

    float           m_TextPos;


  public:

    Extro();
    ~Extro();


    void            Render();

    virtual void    Update();
    virtual void    UpdateTimed( const float ElapsedTime );

};

